<?php

include ("src/jpgraph.php");
include ("src/jpgraph_bar.php");

// Some data
$datay1=array(18);
$datay2=array(31);
$datay3=array(3);
$targ=array(" ");

// Create the basic graph
$graph = new Graph(450,250,'auto');	
$graph->SetScale("textlin");
$graph->img->SetMargin(50,80,50,30);

// Adjust the position of the legend box
$graph->legend->Pos(0,0.02);

// Adjust the color for theshadow of the legend
$graph->legend->SetShadow('darkgray@0.5');
$graph->legend->SetFillColor('lightblue@0.3');

// Get localised version of the month names el nombre en las Y
$graph->xaxis->SetTickLabels($targ);

// Set a nice summer (in Stockholm) image
$graph->SetBackgroundImage('images/templatemo_logo.png',BGIMG_COPY);

// Set axis titles and fonts
$graph->xaxis->title->Set('Ao 2011');
//$graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
$graph->xaxis->title->SetColor('black');

//$graph->xaxis->SetFont(FF_FONT1,FS_BOLD);
$graph->xaxis->SetColor('black');

//$graph->yaxis->SetFont(FF_FONT1,FS_BOLD);
$graph->yaxis->SetColor('black');

//$graph->ygrid->Show(false);
$graph->ygrid->SetColor('black@0.5');

// Setup graph title
$graph->title->Set('Tipo de Renta');
// Some extra margin (from the top)
$graph->title->SetMargin(3);
//$graph->title->SetFont(FF_ARIAL,FS_NORMAL,12);

// Create the three var series we will combine
$bplot1 = new BarPlot($datay1);
$bplot2 = new BarPlot($datay2);
$bplot3 = new BarPlot($datay3);

// Setup the colors with 40% transparency (alpha channel)
$bplot1->SetFillColor('pink@0.4');
$bplot2->SetFillColor('yellow@0.4');
$bplot3->SetFillColor('green@0.4');

// Setup legends
$bplot1->SetLegend('Renta');
$bplot2->SetLegend('Renta Nueva');
$bplot3->SetLegend('Seguimiento');

// Setup each bar with a shadow of 50% transparency
$bplot1->SetShadow('black@0.4');
$bplot2->SetShadow('black@0.4');
$bplot3->SetShadow('black@0.4');

$gbarplot = new GroupBarPlot(array($bplot1,$bplot2,$bplot3)); // array($bplot1,$bplot2,$bplot3)
$gbarplot->SetWidth(0.6);
$graph->Add($gbarplot);

$graph->Stroke();
?>

