<?php session_start(); 
    
    if(!isset($_SESSION['usuario_puesto']) && ($_SESSION['usuario_puesto'] > 3) ){ 
        echo "Acceso denegado...";
        die();
  	}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte general</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.7/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.3.1/dist/js/bootstrap.min.js"></script>
	<script src="https://code.jquery.com/jquery-3.6.1.js"></script>
	<link rel="stylesheet" href="css/calendario/pikaday.css?v=1.0.0">
	<link rel="stylesheet" href="css/calendario/triangle.css?v=1.0.0">
	<link rel="stylesheet" href="css/custom.css?v=1.0.0">
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.11.2/css/all.css">
	<style>
	.fa, .fas {
		font-weight: 900;
		float: right;
	}
	.h5, h5 {
		font-size: 1rem;
	}
	</style>
</head>
<body>
<div class="container">
<header>
	<div class="pricing-header p-3 pb-md-4 mx-auto text-center">
      <h3 class="display-5 fw-normal">Reporte de ventas</h3>
      <p class="fs-5 text-muted">
		<form>
		  <div class="form-row">

			<div class="form-group col-md-3">
				<select name="mes" id="mes" class="form-control">
				  <option>Seleccione Mes...</option>
				  <option value="ENERO">ENERO</option>
				  <option value="FEBRERO">FEBRERO</option>
				  <option value="MARZO">MARZO</option>
				  <option value="ABRIL">ABRIL</option>
				  <option value="MAYO">MAYO</option>
				  <option value="JUNIO">JUNIO</option>
				  <option value="JULIO">JULIO</option>
				  <option value="AGOSTO">AGOSTO</option>
				  <option value="SEPTIEMBRE">SEPTIEMBRE</option>
				  <option value="OCTUBRE">OCTUBRE</option>
				  <option value="NOVIEMBRE">NOVIEMBRE</option>
				  <option value="DICIEMBRE">DICIEMBRE</option>
				</select>
			</div>
			<div class="form-group col-md-3">
				<select name="anio" id="anio" class="form-control">
				  <option>Seleccione Año...</option>
					<?php 
						for($i=date('Y');$i>=2021;$i--){
							echo "<option value='".$i."'>".$i."</option>";
						}
					?>
				</select>
			</div>
			<div class="form-group col-md-3">
				<select id="inputEjecutivo" class="form-control">
				  <option selected>Seleccione ejecutivo...</option>
				  <option value="todos">REPORTE GENERAL</option>
				  <option value="equipo">REPORTE DE VENTAS EQUIPO</option>
				</select>
			</div>
			<div  class="form-group col-md-3">
				<button type="button" id="inputGenerar" class="btn btn-primary">Generar reporte</button>
			</div>
		  </div>
		</form>
	  </p>
    </div>
</header>


  <div class="row md-accordion">
        <input type="hidden" name="userReporte" id="userReporte" value="<?php echo $_SESSION['usuario_login']; ?>">
        <div class="col-lg-4">
            <div class="card bg-light mb-3" style="max-width: 36rem;">
                <div class="card-header"> 
				  <a class="card-link collapsed" data-toggle="collapse" href="#collapseOne" aria-expanded="true" class="collapsed">
					<h5 class="mb-0">PROSPECCIÓN <i class="fas fa-angle-down rotate-icon"></i></h5>
				  </a>
				</div>
	  
				<div id="collapseOne" class="collapse hide">
					<div class="card-body">
					  <p class="card-text">
						<table class="table" id="data-table-prospecto">
						  <thead>
							<tr>
							  <th scope="col">PROSPECCIÓN</th>
							  <th scope="col">TOTAL</th>
							</tr>
						  </thead>
						  <tbody id="data-prospecto">
							
						  </tbody>
						</table>
					  </p>
					</div>
				</div>
            </div>
        </div>
		
		<div class="col-lg-4">
            <div class="card bg-light mb-3" style="max-width: 36rem;">
                <div class="card-header">
				  <a class="card-link collapsed" data-toggle="collapse" href="#collapseMedio" aria-expanded="true" class="collapsed">
				    <h5 class="mb-0">MEDIOS <i class="fas fa-angle-down rotate-icon"></i></h5>
				  </a>
				</div>
				<div id="collapseMedio" class="collapse hide">
					<div class="card-body">
					  <p class="card-text">
						<table class="table" id="data-table-medio">
						  <thead>
							<tr>
							  <th scope="col">MEDIO</th>
							  <th scope="col">TOTAL</th>
							</tr>
						  </thead>
						  <tbody id="data-medio">
							
						  </tbody>
						</table>
					  </p>
					</div>
                </div>
            </div>
        </div>
		
		<div class="col-lg-4">
            <div class="card bg-light mb-3" style="max-width: 36rem;">
                <div class="card-header"> 
				  <a class="card-link collapsed" data-toggle="collapse" href="#collapseSubMedio" aria-expanded="true" class="collapsed">  <h5 class="mb-0">SUBMEDIOS <i class="fas fa-angle-down rotate-icon"></i></h5>
				  </a>
				</div>
				<div id="collapseSubMedio" class="collapse hide">
					<div class="card-body">
					  <p class="card-text">
						<table class="table" id="data-table-submedio">
						  <thead>
							<tr>
							  <th scope="col">SUBMEDIO</th>
							  <th scope="col">TOTAL</th>
							</tr>
						  </thead>
						  <tbody id="data-submedio">
							
						  </tbody>
						</table>
					  </p>
					</div>
                </div>
            </div>
        </div>
      
        <div class="col-lg-4">
            <div class="card bg-light mb-3" style="max-width: 36rem;">
                <div class="card-header">
					<a class="card-link collapsed" data-toggle="collapse" href="#collapseMotivos" aria-expanded="true" class="collapsed"><h5 class="mb-0">MOTIVOS <i class="fas fa-angle-down rotate-icon"></i></h5></a>
				</div>
				<div id="collapseMotivos" class="collapse hide">
					<div class="card-body">
					  <p class="card-text">
						<table class="table" id="data-table-motivo">
						  <thead>
							<tr>
							  <th scope="col">MOTIVO</th>
							  <th scope="col">TOTAL</th>
							</tr>
						  </thead>
						  <tbody id="data-motivo">
							
						  </tbody>
						</table>
					  </p>
					</div>
                </div>
            </div>
        </div>

		<div class="col-lg-4">
            <div class="card bg-light mb-3" style="max-width: 36rem;">
                <div class="card-header">
					<a class="card-link collapsed" data-toggle="collapse" href="#collapseEstancia" aria-expanded="true" class="collapsed"><h5 class="mb-0">ESTANCIA <i class="fas fa-angle-down rotate-icon"></i></h5></a>
				</div>
				<div id="collapseEstancia" class="collapse hide">
					<div class="card-body">
					  <p class="card-text">
						<table class="table" id="data-table-estancia">
						  <thead>
							<tr>
							  <th scope="col">ESTANCIA</th>
							  <th scope="col">TOTAL</th>
							</tr>
						  </thead>
						  <tbody id="data-estancia">
							
						  </tbody>
						</table>
					  </p>
					</div>
                </div>
            </div>
        </div>
		
		<div class="col-lg-4">
            <div class="card bg-light mb-3" style="max-width: 36rem;">
                <div class="card-header">
					<a class="card-link collapsed" data-toggle="collapse" href="#collapseIngresos" aria-expanded="true" class="collapsed"><h5 class="mb-0">INGRESOS <i class="fas fa-angle-down rotate-icon"></i></h5></a>
				</div>
				<div id="collapseIngresos" class="collapse hide">
					<div class="card-body">
					  <p class="card-text">
						<table class="table" id="data-table-ingresos">
						  <thead>
							<tr>
								<th scope="col">META USD</th>
								<th scope="col">REAL USD</th>
								<th scope="col">%</th>
							</tr>
						  </thead>
						  <tbody id="data-ingresos">
							
						  </tbody>
						</table>
						<table class="table" id="data-table-ingresosxpropiedad">
						  <thead>
							<tr>
								<th scope="col">PROPIEDAD</th>
								<th scope="col">MONTO USD</th>
							</tr>
						  </thead>
						  <tbody id="data-ingresos-propiedad">
							
						  </tbody>
						  <tfoot>
							<tr>
								<th scope="col">TOTAL</th>
								<th scope="col" id='totalpropiedades'></th>
							</tr>
						  </tfoot>
						</table>
					  </p>
					</div>
                </div>
            </div>
        </div>
		  
	  
    </div>

</div>
<script src="js/calendario/moment.js"></script>
<script src="js/calendario/pikaday.js"></script>
<script src="js/reporte-gral-view.js?v=1.0"></script>
</body>
</html>